using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hiveAdiz
{
	public class AdizRewardedInterstitial
	{

		private static AdizRewardedInterstitial instance = null;

		private AdizRewardedInterstitial() {}

		~AdizRewardedInterstitial() {
			//
		}

		private string adKey = "";

		public static AdizRewardedInterstitial Initialize(AdEventHandlers handler) {

			string defaultKey = AdizCallbackManager.defaultRewardedInterstitialKey;
			if(string.IsNullOrEmpty(defaultKey)) { 
				AdizLogger.d("adKey is null or empty.");
				return null; 
			}

			instance = new AdizRewardedInterstitial();
			instance.internalInit(defaultKey, handler);
			return instance;
		}

		public static AdizRewardedInterstitial Initialize(string hiveAdKey, AdEventHandlers handler) {

			if(string.IsNullOrEmpty(hiveAdKey)) { 
				AdizLogger.d("adKey is null or empty.");
				return null; 
			}
			
			instance = new AdizRewardedInterstitial();
			instance.internalInit(hiveAdKey, handler);
			return instance;
		}

		public static AdizRewardedInterstitial InitializeWithPlacementId(string placementId, AdEventHandlers handler) {

			if(string.IsNullOrEmpty(placementId)) { 
				AdizLogger.d("placementId is null or empty.");
				return null; 
			}

			string hiveAdKey = AdizUnityNativeCaller.Instance.GetHiveAdKeyFromPlacementId(placementId);
			if(string.IsNullOrEmpty(hiveAdKey)) { 
				AdizLogger.d("placementId is invalid");
				return null; 
			}

			instance = new AdizRewardedInterstitial();
			instance.internalInit(hiveAdKey, handler);
			return instance;
		}

		private void release() {
			if(AdizCallbackManager.callbackHandler.ContainsKey(adKey)) {
				AdizCallbackManager.callbackHandler.Remove(adKey);	
			}

			instance = null;
		}
		
	#if UNITY_ANDROID && !UNITY_EDITOR
		
		private AndroidJavaObject currentActivity = null;
		private AndroidJavaObject hiveAdizPlugin = null;

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			AdizLogger.d("AdizRewardedInterstitial Init "+hiveAdKey);

			AndroidJavaClass jc = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			currentActivity = jc.GetStatic<AndroidJavaObject>("currentActivity");
			hiveAdizPlugin = new AndroidJavaObject("com.hive.adiz.plugin.AdizUnityRewardedInterstitial");

			adKey = hiveAdKey;
			hiveAdizPlugin.Call("initialize", currentActivity, hiveAdKey);
			
			if(AdizCallbackManager.callbackHandler.ContainsKey(hiveAdKey)) {
				AdizCallbackManager.callbackHandler.Remove(hiveAdKey);	
			}
			AdizCallbackManager.callbackHandler.Add(hiveAdKey, handler);
		}

		public void Load() {
			AdizLogger.d("AdizRewardedInterstitial Load");
			hiveAdizPlugin.Call("load");
		}

		public void Show() {
			AdizLogger.d("AdizRewardedInterstitial Show");
			hiveAdizPlugin.Call("show");
		}

		public void Destroy() {
			hiveAdizPlugin.Call("destroy");
			release();
		}

		public bool IsInitialized() {
			return hiveAdizPlugin.Call<bool>("isInitialized");
		}

		public bool IsLoaded() {
			return hiveAdizPlugin.Call<bool>("isLoaded");
		}

	#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void Adiz_RewardedInterstitialInitialize(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_RewardedInterstitialLoad(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_RewardedInterstitialShow(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_RewardedInterstitialDestroy(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern bool Adiz_RewardedInterstitialIsInitialized(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern bool Adiz_RewardedInterstitialIsLoaded(string hiveAdKey);

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			AdizLogger.d("AdizRewardedInterstitial Init "+hiveAdKey);
			adKey = hiveAdKey;
			
			if(AdizCallbackManager.callbackHandler.ContainsKey(hiveAdKey)) {
				AdizCallbackManager.callbackHandler.Remove(hiveAdKey);	
			}
			AdizCallbackManager.callbackHandler.Add(hiveAdKey, handler);

			Adiz_RewardedInterstitialInitialize(hiveAdKey);
		}

		public void Load() {
			AdizLogger.d("AdizRewarded Load");
			Adiz_RewardedInterstitialLoad(adKey);
		}			

		public void Show() {
			AdizLogger.d("AdizRewardedInterstitial Show");
			Adiz_RewardedInterstitialShow(adKey);
		}

		public void Destroy() {
			AdizLogger.d("AdizRewardedInterstitial Destroy");
			Adiz_RewardedInterstitialDestroy(adKey);
			release();
		}

		public bool IsInitialized() {
			return Adiz_RewardedInterstitialIsInitialized(adKey);
		}

		public bool IsLoaded() {
			return Adiz_RewardedInterstitialIsLoaded(adKey);
		}
	#else

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			
		}

		public void Load() {
			
		}			

		public void Show() {
			
		}

		public void Destroy() {
			
		}
		
		public bool IsInitialized() {
			return false;
		}

		public bool IsLoaded() {
			return false;
		}
	#endif
		
	}
}